<?php

namespace App\Http\Controllers\Restaurant;

use App\Http\Controllers\Controller;
use App\Models\Delivery;
use App\Models\WalletTransaction;
use Illuminate\Http\Request;

class WalletController extends Controller
{
    public function index(Request $request)
    {
        $restaurant = $request->user()->restaurant;

        if (!$restaurant) {
            abort(403);
        }

        $transactions = WalletTransaction::query()
            ->where('owner_type', 'restaurant')
            ->where('owner_id', $restaurant->id)
            ->latest()
            ->paginate(15);

        $deliveries = Delivery::query()
            ->where('restaurant_id', $restaurant->id)
            ->latest()
            ->take(20)
            ->get();

        return view('restaurant.wallet', [
            'restaurant' => $restaurant,
            'transactions' => $transactions,
            'deliveries' => $deliveries,
        ]);
    }
}
