<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureUserIsAdmin
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if (!$user) {
            return redirect()->route('login');
        }

        if (!$user->is_admin) {
            // Better UX: if a restaurant/courier hits /admin (e.g. browser back),
            // send them back to their own panel instead of a scary 403 page.
            if ($request->expectsJson()) {
                abort(403);
            }
            return redirect()->route('dashboard');
        }

        return $next($request);
    }
}
