<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Courier extends Model
{
    /** @use HasFactory<\Database\Factories\CourierFactory> */
    use HasFactory;

    protected $fillable = [
        'zone_id',
        'name',
        'phone',
        'email',
        'vehicle_type',
        'notes',
        'wallet_balance',
        'wallet_withdrawn',
        'is_active',
        'is_online',
        'last_lat',
        'last_lng',
        'last_seen_at',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_online' => 'boolean',
        'last_seen_at' => 'datetime',
    ];

    public function zone()
    {
        return $this->belongsTo(Zone::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function deliveries()
    {
        return $this->hasMany(Delivery::class);
    }
}
