<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model
{
    /** @use HasFactory<\Database\Factories\RestaurantFactory> */
    use HasFactory;

    protected $fillable = [
        'zone_id',
        'name',
        'contact_name',
        'phone',
        'email',
        'address',
        'lat',
        'lng',
        'notes',
        'wallet_balance',
        'delivery_fee',
        'is_active',
    ];

    public function zone()
    {
        return $this->belongsTo(Zone::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function deliveries()
    {
        return $this->hasMany(Delivery::class);
    }
}
