<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('courier_id')->nullable()->after('restaurant_id')->constrained()->nullOnDelete();
        });

        Schema::table('deliveries', function (Blueprint $table) {
            $table->foreignId('courier_id')->nullable()->after('restaurant_id')->constrained()->nullOnDelete();
        });

        Schema::table('couriers', function (Blueprint $table) {
            $table->decimal('last_lat', 10, 7)->nullable()->after('notes');
            $table->decimal('last_lng', 10, 7)->nullable()->after('last_lat');
            $table->timestamp('last_seen_at')->nullable()->after('last_lng');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropConstrainedForeignId('courier_id');
        });

        Schema::table('deliveries', function (Blueprint $table) {
            $table->dropConstrainedForeignId('courier_id');
        });

        Schema::table('couriers', function (Blueprint $table) {
            $table->dropColumn(['last_lat', 'last_lng', 'last_seen_at']);
        });
    }
};
