<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('deliveries', function (Blueprint $table) {
            $table->decimal('delivery_fee', 10, 2)->default(0)->after('notes');
            $table->timestamp('fee_transferred_at')->nullable()->after('delivery_fee');
            $table->timestamp('completed_at')->nullable()->after('fee_transferred_at');
        });
    }

    public function down(): void
    {
        Schema::table('deliveries', function (Blueprint $table) {
            $table->dropColumn(['delivery_fee', 'fee_transferred_at', 'completed_at']);
        });
    }
};
