<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('deliveries', function (Blueprint $table) {
            if (!Schema::hasColumn('deliveries', 'is_urgent')) {
                $table->boolean('is_urgent')->default(false)->after('payment_method');
            }
            if (!Schema::hasColumn('deliveries', 'urgent_requested_at')) {
                $table->timestamp('urgent_requested_at')->nullable()->after('is_urgent');
            }
        });
    }

    public function down(): void
    {
        Schema::table('deliveries', function (Blueprint $table) {
            if (Schema::hasColumn('deliveries', 'urgent_requested_at')) {
                $table->dropColumn('urgent_requested_at');
            }
            if (Schema::hasColumn('deliveries', 'is_urgent')) {
                $table->dropColumn('is_urgent');
            }
        });
    }
};
