<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $adminEmail = env('ADMIN_EMAIL');
        $adminPassword = env('ADMIN_PASSWORD');

        if ($adminEmail && $adminPassword) {
            User::factory()->create([
                'name' => env('ADMIN_NAME', 'Admin'),
                'email' => $adminEmail,
                'password' => $adminPassword,
                'is_admin' => true,
                'role' => 'admin',
            ]);
        }
    }
}
