@php
$configData = Helper::appClasses();
$stats = $stats ?? ['total' => 0, 'active' => 0, 'inactive' => 0, 'balance' => 0];
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Repartidores')

@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss'
])
@endsection

@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'
])
@endsection

@section('page-script')
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const table = document.querySelector('#couriers-table');
    if (table && window.$ && $.fn.DataTable) {
      $('#couriers-table').DataTable({
        order: [[2, 'asc']],
        pageLength: 10,
        language: {
          search: 'Buscar:',
          emptyTable: 'Sin repartidores todavía.'
        }
      });
    }
  });
</script>
@endsection

@section('content')
<div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
  <span></span>
</div>

@if (session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif

<div class="row g-4 mb-4">
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Total</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['total'] }}</h4>
            </div>
            <small class="mb-0">Repartidores registrados</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-primary">
              <i class="icon-base ti tabler-bike icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Activos</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['active'] }}</h4>
            </div>
            <small class="mb-0">En línea</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-success">
              <i class="icon-base ti tabler-circle-check icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Inactivos</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['inactive'] }}</h4>
            </div>
            <small class="mb-0">Sin actividad</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-warning">
              <i class="icon-base ti tabler-alert-triangle icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Saldo total</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">€{{ number_format($stats['balance'], 2) }}</h4>
            </div>
            <small class="mb-0">Monederos</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-info">
              <i class="icon-base ti tabler-wallet icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="card">
  <div class="card-header border-bottom d-flex align-items-center justify-content-between">
    <h5 class="card-title mb-0">Listado de repartidores</h5>
    <a class="btn btn-primary btn-sm" href="{{ route('admin.couriers.create') }}">
      <i class="icon-base ti tabler-plus me-1"></i> Nuevo repartidor
    </a>
  </div>
  <div class="card-datatable table-responsive">
    <table class="table" id="couriers-table">
      <thead class="border-top">
        <tr>
          <th>Nombre</th>
          <th>Zona</th>
          <th>Teléfono</th>
          <th>Saldo</th>
          <th>Retirado</th>
          <th>Estado</th>
          <th class="text-end">Acciones</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($couriers as $courier)
          <tr>
            <td>
              <div class="d-flex align-items-center">
                <div class="avatar me-2">
                  <span class="avatar-initial rounded-circle bg-label-primary">
                    {{ strtoupper(substr($courier->name, 0, 2)) }}
                  </span>
                </div>
                <div class="d-flex flex-column">
                  <span class="fw-medium">{{ $courier->name }}</span>
                  <small class="text-muted">{{ $courier->email ?? '—' }}</small>
                </div>
              </div>
            </td>
            <td>{{ $courier->zone?->name ?? '-' }}</td>
            <td>{{ $courier->phone ?? '-' }}</td>
            <td>€{{ number_format($courier->wallet_balance, 2) }}</td>
            <td>€{{ number_format($courier->wallet_withdrawn, 2) }}</td>
            <td>
              <span class="badge bg-{{ $courier->is_active ? 'success' : 'secondary' }}">
                {{ $courier->is_active ? 'Activo' : 'Inactivo' }}
              </span>
            </td>
            <td class="text-end">
              <a class="btn btn-sm btn-icon btn-outline-secondary" href="{{ route('admin.couriers.show', $courier) }}" title="Ver">
                <i class="icon-base ti tabler-eye"></i>
              </a>
              <a class="btn btn-sm btn-icon btn-outline-primary" href="{{ route('admin.couriers.edit', $courier) }}" title="Editar">
                <i class="icon-base ti tabler-edit"></i>
              </a>
              <form class="d-inline" method="POST" action="{{ route('admin.couriers.destroy', $courier) }}">
                @csrf
                @method('DELETE')
                <button class="btn btn-sm btn-icon btn-outline-danger" type="submit" onclick="return confirm('¿Eliminar repartidor?')" title="Eliminar">
                  <i class="icon-base ti tabler-trash"></i>
                </button>
              </form>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>
@endsection
