@php
  $statusMap = [
    'pending' => ['Pendiente', 'warning'],
    'confirmed' => ['Confirmado', 'info'],
    'at_restaurant' => ['En restaurante', 'primary'],
    'en_route' => ['En camino', 'secondary'],
    'delivered' => ['Entregado', 'success'],
    'cancelled' => ['Cancelado', 'danger'],
  ];
  [$statusLabel, $statusColor] = $statusMap[$delivery->status] ?? ['Pendiente', 'secondary'];

  $fmtDate = function ($dt) {
    if (!$dt) return '-';
    return ucfirst($dt->locale('es')->translatedFormat('d F Y'));
  };
  $fmtTime = function ($dt) {
    if (!$dt) return '';
    return $dt->format('h:i') . ' ' . ucfirst(strtolower($dt->format('A')));
  };
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Orden #' . $delivery->id)

@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/animate-css/animate.scss',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss'
])
@endsection

@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'
])
@endsection

@section('page-script')
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const statusSelect = document.getElementById('order-status-select');
    const statusConfirmModal = new bootstrap.Modal(document.getElementById('statusConfirmModal'));
    const cancelModal = new bootstrap.Modal(document.getElementById('statusCancelModal'));
    const statusInput = document.getElementById('status-confirm-input');
    const cancelStatusInput = document.getElementById('status-cancel-input');
    const statusLabel = document.getElementById('status-confirm-label');
    const statusCurrent = statusSelect ? statusSelect.dataset.current : '';
    const statusLabels = {
      pending: 'pendiente',
      confirmed: 'confirmado',
      at_restaurant: 'en restaurante',
      en_route: 'en camino',
      delivered: 'entregado',
      cancelled: 'cancelado'
    };

    if (statusSelect) {
      statusSelect.addEventListener('change', (event) => {
        const next = event.target.value;
        if (!next || next === statusCurrent) {
          return;
        }

        if (next === 'cancelled') {
          cancelStatusInput.value = next;
          cancelModal.show();
          return;
        }

        statusInput.value = next;
        if (statusLabel) {
          const currentLabel = statusLabels[statusCurrent] ?? statusCurrent;
          const nextLabel = statusLabels[next] ?? next;
          statusLabel.textContent = `¿Deseas cambiar el estado de la orden de ${currentLabel} a ${nextLabel}?`;
        }
        statusConfirmModal.show();
      });
    }

    document.querySelectorAll('[data-confirm-delete]').forEach((btn) => {
      btn.addEventListener('click', (e) => {
        e.preventDefault();
        const form = btn.closest('form');
        if (!form) return;
        Swal.fire({
          title: 'Eliminar orden?',
          text: 'Esta accion no se puede deshacer.',
          icon: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Eliminar',
          cancelButtonText: 'Cancelar'
        }).then((result) => {
          if (result.isConfirmed) form.submit();
        });
      });
    });
  });
</script>
@endsection

@section('content')
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 row-gap-3">
  <div class="d-flex flex-column justify-content-center">
    <div class="mb-1">
      <span class="h5">Orden #{{ $delivery->id }}</span>
      <span class="badge bg-label-{{ $statusColor }} ms-2">{{ $statusLabel }}</span>
      @if ($delivery->is_urgent)
        <span class="badge bg-label-warning ms-1">Urgente</span>
      @endif
      <span class="badge bg-label-secondary ms-1">{{ $delivery->payment_method === 'cash' ? 'Efectivo' : 'Wallet' }}</span>
    </div>
    <p class="mb-0">
      {{ $fmtDate($delivery->created_at) }}
      <span class="text-muted">·</span>
      {{ $fmtTime($delivery->created_at) }}
    </p>
  </div>
  <div class="d-flex align-content-center flex-wrap gap-2">
    <a class="btn btn-label-secondary" href="{{ route('admin.orders.index') }}">
      <i class="icon-base ti tabler-arrow-left me-1"></i> Volver
    </a>
  </div>
</div>

<div class="row">
  <div class="col-12 col-lg-8">
    <div class="card mb-4">
      <div class="card-header">
        <h5 class="card-title m-0">Detalles de la entrega</h5>
      </div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-12 col-md-6">
            <div class="mb-2 text-muted">Restaurante</div>
            <div class="fw-semibold">{{ $delivery->restaurant?->name ?? '-' }}</div>
            <div class="text-muted small">{{ $delivery->restaurant?->zone?->name ?? '—' }}</div>
            <div class="text-muted small">{{ $delivery->restaurant?->address ?? '—' }}</div>
          </div>
          <div class="col-12 col-md-6">
            <div class="mb-2 text-muted">Repartidor</div>
            <div class="fw-semibold">{{ $delivery->courier?->name ?? 'Sin asignar' }}</div>
            <div class="text-muted small">{{ $delivery->courier?->phone ?? '—' }}</div>
            <div class="text-muted small">{{ $delivery->courier?->zone?->name ?? '—' }}</div>
          </div>
          <div class="col-12">
            <hr class="my-3" />
          </div>
          <div class="col-12 col-md-6">
            <div class="mb-2 text-muted">Cliente</div>
            <div class="fw-semibold">{{ $delivery->customer_name ?? 'Por definir' }}</div>
            <div class="text-muted small">{{ $delivery->customer_phone ?: '-' }}</div>
          </div>
          <div class="col-12 col-md-6">
            <div class="mb-2 text-muted">Dirección de entrega</div>
            <div class="fw-semibold">{{ $delivery->delivery_address ?? 'Por definir' }}</div>
            @if ($delivery->delivery_address_extra)
              <div class="text-muted small">{{ $delivery->delivery_address_extra }}</div>
            @endif
            @if ($delivery->delivery_lat && $delivery->delivery_lng)
              <div class="text-muted small">({{ $delivery->delivery_lat }}, {{ $delivery->delivery_lng }})</div>
            @endif
          </div>
          @if ($delivery->notes)
            <div class="col-12">
              <hr class="my-3" />
              <div class="mb-2 text-muted">Notas</div>
              <div>{{ $delivery->notes }}</div>
            </div>
          @endif
        </div>
      </div>
    </div>

    <div class="card mb-4">
      <div class="card-header">
        <h5 class="card-title m-0">Seguimiento</h5>
      </div>
      <div class="card-body pt-2">
        <ul class="timeline mb-0">
          <li class="timeline-item timeline-item-transparent">
            <span class="timeline-point timeline-point-primary"></span>
            <div class="timeline-event">
              <div class="timeline-header">
                <h6 class="mb-0">Pedido creado</h6>
                <small class="text-body-secondary">
                  {{ $fmtDate($delivery->created_at) }} · {{ $fmtTime($delivery->created_at) }}
                </small>
              </div>
              <p class="mt-2 mb-0">Restaurante: {{ $delivery->restaurant?->name ?? '-' }}</p>
            </div>
          </li>
          @if ($delivery->is_urgent && $delivery->urgent_requested_at)
            <li class="timeline-item timeline-item-transparent">
              <span class="timeline-point timeline-point-warning"></span>
              <div class="timeline-event">
                <div class="timeline-header">
                  <h6 class="mb-0">Solicitud urgente</h6>
                  <small class="text-body-secondary">
                    {{ $fmtDate($delivery->urgent_requested_at) }} · {{ $fmtTime($delivery->urgent_requested_at) }}
                  </small>
                </div>
                <p class="mt-2 mb-0">Se solicitó un repartidor urgente.</p>
              </div>
            </li>
          @endif
          <li class="timeline-item timeline-item-transparent">
            <span class="timeline-point timeline-point-info"></span>
            <div class="timeline-event">
              <div class="timeline-header">
                <h6 class="mb-0">Repartidor</h6>
                <small class="text-body-secondary">{{ $delivery->courier ? 'Asignado' : 'En espera' }}</small>
              </div>
              <p class="mt-2 mb-0">{{ $delivery->courier?->name ?? 'Sin asignar' }}</p>
            </div>
          </li>
          @if ($delivery->status === 'cancelled' && $delivery->cancelled_at)
            <li class="timeline-item timeline-item-transparent">
              <span class="timeline-point timeline-point-danger"></span>
              <div class="timeline-event">
                <div class="timeline-header">
                  <h6 class="mb-0">Cancelado</h6>
                  <small class="text-body-secondary">
                    {{ $fmtDate($delivery->cancelled_at) }} · {{ $fmtTime($delivery->cancelled_at) }}
                  </small>
                </div>
                <p class="mt-2 mb-0">{{ $delivery->cancel_reason ?? 'Cancelado por administrador.' }}</p>
              </div>
            </li>
          @endif
          @if ($delivery->status === 'delivered' && $delivery->completed_at)
            <li class="timeline-item timeline-item-transparent">
              <span class="timeline-point timeline-point-success"></span>
              <div class="timeline-event">
                <div class="timeline-header">
                  <h6 class="mb-0">Entregado</h6>
                  <small class="text-body-secondary">
                    {{ $fmtDate($delivery->completed_at) }} · {{ $fmtTime($delivery->completed_at) }}
                  </small>
                </div>
                <p class="mt-2 mb-0">Entrega completada.</p>
              </div>
            </li>
          @endif
        </ul>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-4">
    <div class="card mb-4">
      <div class="card-header">
        <h5 class="card-title m-0">Configuración de orden</h5>
      </div>
      <div class="card-body">
        <div class="d-flex align-items-center gap-2 mb-3">
          <span class="badge bg-label-{{ $statusColor }}">{{ $statusLabel }}</span>
          @if ($delivery->is_urgent)
            <span class="badge bg-label-warning">Urgente</span>
          @endif
          <span class="badge bg-label-secondary">{{ $delivery->payment_method === 'cash' ? 'Efectivo' : 'Wallet' }}</span>
        </div>
        <div class="mb-3">
          <label class="form-label">Cambiar estado</label>
          <select class="form-select" id="order-status-select" data-current="{{ $delivery->status }}">
            <option value="pending" @selected($delivery->status === 'pending')>Pendiente</option>
            <option value="confirmed" @selected($delivery->status === 'confirmed')>Confirmado</option>
            <option value="at_restaurant" @selected($delivery->status === 'at_restaurant')>En restaurante</option>
            <option value="en_route" @selected($delivery->status === 'en_route')>En camino</option>
            <option value="delivered" @selected($delivery->status === 'delivered')>Entregado</option>
            <option value="cancelled" @selected($delivery->status === 'cancelled')>Cancelado</option>
          </select>
          <div class="form-text">Los cambios requieren confirmación.</div>
        </div>
        <button class="btn btn-outline-primary w-100" type="button" data-bs-toggle="modal" data-bs-target="#assignCourierModal">
          {{ $delivery->courier_id ? 'Cambiar repartidor' : 'Asignar repartidor' }}
        </button>
      </div>
    </div>

    <div class="card mb-4">
      <div class="card-header d-flex align-items-center justify-content-between">
        <h5 class="card-title m-0">Repartidor</h5>
        <button class="btn btn-sm btn-outline-secondary" type="button" data-bs-toggle="modal" data-bs-target="#assignCourierModal">
          {{ $delivery->courier_id ? 'Cambiar' : 'Asignar' }}
        </button>
      </div>
      <div class="card-body">
        @php
          $courierName = $delivery->courier?->name ?? 'Sin asignar';
          $courierInitials = collect(explode(' ', $courierName))
            ->filter()
            ->map(fn ($part) => strtoupper(mb_substr($part, 0, 1)))
            ->take(2)
            ->implode('');
        @endphp
        <div class="d-flex align-items-center gap-3">
          <div class="avatar">
            <span class="avatar-initial rounded-circle bg-label-primary">{{ $courierInitials ?: '-' }}</span>
          </div>
          <div>
            <div class="fw-semibold">{{ $courierName }}</div>
            <div class="text-muted small">{{ $delivery->courier?->phone ?? '—' }}</div>
            <div class="text-muted small">
              {{ $delivery->courier?->is_online ? 'En línea' : 'Desconectado' }}
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="card mb-4">
      <div class="card-header">
        <h5 class="card-title m-0">Cliente</h5>
      </div>
      <div class="card-body">
        @php
          $customerName = $delivery->customer_name ?? 'Por definir';
          $customerInitials = collect(explode(' ', $customerName))
            ->filter()
            ->map(fn ($part) => strtoupper(mb_substr($part, 0, 1)))
            ->take(2)
            ->implode('');
        @endphp
        <div class="d-flex align-items-center gap-3 mb-2">
          <div class="avatar">
            <span class="avatar-initial rounded-circle bg-label-info">{{ $customerInitials ?: '-' }}</span>
          </div>
          <div>
            <div class="fw-semibold">{{ $customerName }}</div>
            <div class="text-muted small">{{ $delivery->customer_phone ?: '-' }}</div>
          </div>
        </div>
        <div class="text-muted small">{{ $delivery->delivery_address ?? 'Por definir' }}</div>
        @if ($delivery->delivery_address_extra)
          <div class="text-muted small">{{ $delivery->delivery_address_extra }}</div>
        @endif
      </div>
    </div>

    <div class="card mb-4">
      <div class="card-header">
        <h5 class="card-title m-0">Restaurante</h5>
      </div>
      <div class="card-body">
        @php
          $restName = $delivery->restaurant?->name ?? 'Restaurante';
          $restInitials = collect(explode(' ', $restName))
            ->filter()
            ->map(fn ($part) => strtoupper(mb_substr($part, 0, 1)))
            ->take(2)
            ->implode('');
        @endphp
        <div class="d-flex align-items-center gap-3 mb-2">
          <div class="avatar">
            <span class="avatar-initial rounded-circle bg-label-warning">{{ $restInitials ?: '-' }}</span>
          </div>
          <div>
            <div class="fw-semibold">{{ $restName }}</div>
            <div class="text-muted small">{{ $delivery->restaurant?->phone ?? '—' }}</div>
          </div>
        </div>
        <div class="text-muted small">{{ $delivery->restaurant?->address ?? '—' }}</div>
        <div class="text-muted small">Zona: {{ $delivery->restaurant?->zone?->name ?? '—' }}</div>
      </div>
    </div>

    <div class="card mb-4">
      <div class="card-header">
        <h5 class="card-title m-0">Pago</h5>
      </div>
      <div class="card-body">
        <div class="d-flex justify-content-between mb-2">
          <span class="text-muted">Metodo</span>
          <span class="fw-semibold">{{ $delivery->payment_method === 'cash' ? 'Efectivo' : 'Wallet' }}</span>
        </div>
        <div class="d-flex justify-content-between mb-2">
          <span class="text-muted">Costo</span>
          <span class="fw-semibold">€{{ number_format($delivery->delivery_fee ?? 0, 2) }}</span>
        </div>
        <div class="d-flex justify-content-between">
          <span class="text-muted">Transferido</span>
          <span class="fw-semibold">{{ $delivery->fee_transferred_at ? 'Si' : 'No' }}</span>
        </div>
      </div>
    </div>

    <div class="card mb-4">
      <div class="card-header">
        <h5 class="card-title m-0">Acciones</h5>
      </div>
      <div class="card-body d-grid gap-2">
        <a class="btn btn-outline-primary" href="{{ route('admin.restaurants.show', $delivery->restaurant_id) }}">
          <i class="icon-base ti tabler-building-store me-1"></i> Ver restaurante
        </a>
        @if ($delivery->courier_id)
          <a class="btn btn-outline-secondary" href="{{ route('admin.couriers.show', $delivery->courier_id) }}">
            <i class="icon-base ti tabler-bike me-1"></i> Ver repartidor
          </a>
        @endif
      </div>
    </div>
  </div>
</div>

<!-- Status confirmation modal -->
<div class="modal fade" id="statusConfirmModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Confirmar cambio</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <p class="mb-0" id="status-confirm-label">¿Deseas cambiar el estado de la orden?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">Cancelar</button>
        <form method="POST" action="{{ route('admin.orders.status', $delivery) }}">
          @csrf
          <input type="hidden" name="status" id="status-confirm-input">
          <button class="btn btn-primary" type="submit">Confirmar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Cancel modal -->
<div class="modal fade" id="statusCancelModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Cancelar orden</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label class="form-label">Motivo de cancelación</label>
          <textarea class="form-control" name="cancel_reason" form="cancel-status-form" rows="4" placeholder="Ej. Cliente no respondió">{{ $delivery->cancel_reason }}</textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">Cerrar</button>
        <form method="POST" action="{{ route('admin.orders.status', $delivery) }}" id="cancel-status-form">
          @csrf
          <input type="hidden" name="status" id="status-cancel-input">
          <button class="btn btn-danger" type="submit">Cancelar orden</button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Assign courier modal -->
<div class="modal fade" id="assignCourierModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Asignar repartidor</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        @if (($couriers ?? collect())->isEmpty())
          <div class="text-muted">No hay repartidores activos disponibles.</div>
        @else
          <form method="POST" action="{{ route('admin.orders.assign', $delivery) }}" id="assign-courier-form">
            @csrf
            <div class="list-group">
              @foreach ($couriers as $courier)
                @php
                  $name = $courier->name ?? 'Repartidor';
                  $initials = collect(explode(' ', $name))
                    ->filter()
                    ->map(fn ($part) => strtoupper(mb_substr($part, 0, 1)))
                    ->take(2)
                    ->implode('');
                @endphp
                <label class="list-group-item d-flex align-items-center gap-3">
                  <input class="form-check-input mt-0" type="radio" name="courier_id" value="{{ $courier->id }}" @checked($delivery->courier_id === $courier->id)>
                  <span class="avatar">
                    <span class="avatar-initial rounded-circle bg-label-primary">{{ $initials }}</span>
                  </span>
                  <span class="flex-grow-1">
                    <span class="fw-semibold d-block">{{ $name }}</span>
                    <span class="text-muted small d-block">{{ $courier->phone ?? '—' }}</span>
                    <span class="text-muted small d-block">Zona: {{ $courier->zone?->name ?? '—' }}</span>
                  </span>
                  <span class="badge {{ $courier->is_online ? 'bg-label-success' : 'bg-label-secondary' }}">
                    {{ $courier->is_online ? 'En línea' : 'Desconectado' }}
                  </span>
                  @if (!$courier->is_online)
                    <button class="btn btn-sm btn-outline-success" type="submit" form="force-online-{{ $courier->id }}">
                      Forzar en línea
                    </button>
                  @endif
                </label>
              @endforeach
            </div>
          </form>
          @foreach ($couriers as $courier)
            @if (!$courier->is_online)
              <form method="POST" action="{{ route('admin.couriers.force-online', $courier) }}" id="force-online-{{ $courier->id }}">
                @csrf
              </form>
            @endif
          @endforeach
        @endif
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">Cerrar</button>
        @if (($couriers ?? collect())->isNotEmpty())
          <button class="btn btn-primary" type="submit" form="assign-courier-form">Asignar</button>
        @endif
      </div>
    </div>
  </div>
</div>
@endsection
