@php
$pageConfigs = ['navbarType' => 'hidden', 'contentLayout' => 'wide'];
$configData = Helper::appClasses();
$statusMap = [
  'delivered' => ['Entregado', 'success'],
  'cancelled' => ['Cancelado', 'danger'],
];
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Registros')

@section('content')
<div class="courier-records">
  <div class="records-hero">
    <div>
      <h3 class="mb-1">Registros</h3>
      <p class="text-muted mb-0">Selecciona un día para ver los pedidos completados.</p>
    </div>
    <div class="records-info">
      <i class="icon-base ti tabler-history"></i>
    </div>
  </div>

  <div class="records-panel">
    <h5 class="section-title">Días con pedidos</h5>
    <div class="day-list">
      @forelse ($days as $day)
        @php
          $dayValue = $day->day;
          $isActive = ($selectedDay ?? '') === $dayValue;
        @endphp
        <a class="day-pill {{ $isActive ? 'active' : '' }}" href="{{ route('courier.records.index', ['day' => $dayValue]) }}">
          <span>{{ \Carbon\Carbon::parse($dayValue)->format('d/m/Y') }}</span>
          <span class="day-amount">{{ $day->total }} pedidos</span>
        </a>
      @empty
        <div class="text-muted">No hay registros todavía.</div>
      @endforelse
    </div>
  </div>

  @if ($selectedDay)
    <div class="card mt-3">
      <div class="card-header">
        <div class="d-flex align-items-center justify-content-between">
          <div class="d-flex align-items-center gap-2">
            <a class="btn btn-icon btn-outline-secondary btn-sm" href="{{ route('courier.records.index') }}">
              <i class="icon-base ti tabler-arrow-left"></i>
            </a>
            <h6 class="mb-0">Pedidos del {{ \Carbon\Carbon::parse($selectedDay)->format('d/m/Y') }}</h6>
          </div>
          <span class="badge bg-label-secondary">{{ $deliveries->total() }}</span>
        </div>
      </div>
      <div class="card-body">
        @forelse ($deliveries as $delivery)
          <div class="record-item">
            <div class="record-left">
              <div class="record-id">#{{ $delivery->id }}</div>
              <div class="record-customer">{{ $delivery->customer_name }}</div>
              <div class="record-address">{{ $delivery->delivery_address }}</div>
            </div>
            <div class="record-right">
              <span class="badge bg-success">Completado</span>
              <div class="record-date">{{ $delivery->created_at->format('d/m/Y H:i') }}</div>
            </div>
          </div>
        @empty
          <div class="text-muted">No hay pedidos para este día.</div>
        @endforelse
        <div class="mt-3">
          {{ $deliveries->links() }}
        </div>
      </div>
    </div>
  @endif

  <nav class="courier-bottom-nav">
    <a href="{{ route('courier.dashboard') }}">
      <i class="icon-base ti tabler-map"></i>
    </a>
    <a href="{{ route('courier.orders.index') }}">
      <i class="icon-base ti tabler-clipboard-text"></i>
    </a>
    <a class="active" href="{{ route('courier.records.index') }}">
      <i class="icon-base ti tabler-history"></i>
    </a>
    <a href="{{ route('courier.profile.edit') }}">
      <i class="icon-base ti tabler-user"></i>
    </a>
  </nav>
</div>
@endsection

@section('page-style')
  <style>
    .courier-records {
      min-height: 100vh;
      display: grid;
      gap: 16px;
    }
    .records-hero {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 8px 12px;
      border-radius: 16px;
      background: linear-gradient(135deg, rgba(46, 204, 113, 0.12), rgba(255, 255, 255, 0));
      border: 1px solid rgba(15, 20, 34, 0.08);
      height: auto;
      min-height: unset;
      gap: 10px;
    }
    .records-info {
      width: 32px;
      height: 32px;
      border-radius: 10px;
      background: #fff;
      display: grid;
      place-items: center;
      box-shadow: 0 6px 16px rgba(15, 20, 34, 0.08);
      color: #2ecc71;
    }
    .records-panel {
      background: #fff;
      border-radius: 18px;
      border: 1px solid rgba(15, 20, 34, 0.08);
      padding: 16px;
      box-shadow: 0 8px 18px rgba(15, 20, 34, 0.06);
    }
    .section-title {
      font-weight: 700;
      margin-bottom: 12px;
    }
    .day-list {
      display: grid;
      gap: 10px;
    }
    .day-pill {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 12px 16px;
      border-radius: 14px;
      border: 1px solid rgba(15, 20, 34, 0.1);
      text-decoration: none;
      color: #2f2b3d;
      background: #fff;
      font-weight: 600;
    }
    .day-pill.active {
      border-color: rgba(46, 204, 113, 0.5);
      background: rgba(46, 204, 113, 0.12);
      color: #1f8f54;
    }
    .day-amount {
      font-size: 13px;
      color: #6f6b7d;
      font-weight: 500;
    }
    .record-item {
      display: flex;
      justify-content: space-between;
      gap: 12px;
      padding: 12px 0;
      border-bottom: 1px solid rgba(15, 20, 34, 0.08);
    }
    .record-item:last-child {
      border-bottom: none;
    }
    .record-id {
      font-weight: 700;
      color: #2f2b3d;
    }
    .record-customer {
      font-weight: 600;
    }
    .record-address {
      color: #6f6b7d;
      font-size: 13px;
    }
    .record-right {
      text-align: right;
      display: grid;
      gap: 6px;
      font-size: 13px;
    }
    .courier-bottom-nav {
      position: fixed;
      left: 0;
      right: 0;
      bottom: 0;
      background: #fff;
      border-top: 1px solid rgba(15, 20, 34, 0.08);
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      padding: 8px 14px 12px;
      z-index: 20;
    }
    .courier-bottom-nav a {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 2px;
      color: #6f6b7d;
      font-size: 12px;
      text-decoration: none;
    }
    .courier-bottom-nav a i {
      font-size: 20px;
    }
    .courier-bottom-nav a.active {
      color: #28c76f;
      font-weight: 600;
    }
    @media (max-width: 991px) {
      body {
        padding-bottom: 70px;
      }
      #layout-menu,
      .layout-navbar,
      .layout-menu-toggle,
      .content-footer {
        display: none !important;
      }
    }
  </style>
@endsection
